<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class vBDownloads_DataManager_Extensiongroup extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'extensiongroupid' 	=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'title' 			=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_downloads_extensiongroup';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('extensiongroupid = \'%1$s\'', 'extensiongroupid');

	/**
	* Verifies that the extensionid is valid
	*
	* @param	string	extensionid of the tab
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		if (!$this->condition OR $this->existing['title'] != $title)
		{
			// Check for existing download of this name
			if ($existing = VBDOWNLOADS::$db->fetchRow('
				SELECT extensiongroupid
				FROM $dbtech_downloads_extensiongroup
				WHERE title = ?', array($title)
			))
			{
				// Whoopsie, exists
				$this->error('dbtech_downloads_x_already_exists_y', $vbphrase['dbtech_downloads_extensiongroup'], $title);
				return false;
			}
		}

		return true;
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiongroupdata_presave')) ? eval($hook) : false;		

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiongroupdata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiongroupdata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBDOWNLOADS_CACHE::build('extensiongroup');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_extensiongroupdata_delete')) ? eval($hook) : false;
		
		// Remove extensions tied to this group
		VBDOWNLOADS::$db->delete('dbtech_downloads_extension', array('extensiongroupid' => $this->existing['extensiongroupid']), 'WHERE extensiongroupid = ?');
 
		// Rebuild the cache
		VBDOWNLOADS_CACHE::build('extensiongroup');
		VBDOWNLOADS_CACHE::build('extension');
		
		return true;
	}
}